#version 120
#extension GL_EXT_gpu_shader4 : enable 
			
uniform sampler2D	waveNormals0,
					//waveHeights0,
					waveNormals1,
					//waveHeights1,
					waveNormalsDetail,
					foam,
					foldmap;
varying vec2 		texcoord0;
varying vec2 		texcoord1;
varying vec2 		texcoord2;
varying vec2 		texcoord3;

varying vec4		pos;
uniform float 		normalScale;
uniform float 		normalScale0;
uniform float 		normalScale1;

//varying vec3		vY;
varying vec3		baseNormal;
uniform float		DeltaT;
varying vec4		wdir;
//varying float 		waveH;
uniform float 		foamDensityMultiplier0;
uniform float 		foamDensityMultiplier1;
uniform vec2		FFTwind;

// ------------------------------------
uniform vec3 		deepColor;
uniform float		specularity;
uniform float 		density;
uniform float 		sss;
uniform float 		roughness;
uniform float 		foamWidth;
//uniform float		matID;	// shallow color and sss color for rivers

// FOAM ------------------------------
const float invWavemapSize=1.0/256.0;
uniform float 		choppiness1;
uniform float 		choppiness0;
//varying vec3		foamAmount;
//varying float		coastDepth;
// ----------------------------------
////////////////////////////
vec2 encode(vec3 n)
{
	n=normalize(n);
	float f = sqrt(8.0*n.z+8.0);
	return n.xy / f + 0.5;
}

void main()
{
	vec3 foamDensity=vec3(0.0,0.0,0.0);

	vec2 vOfs = vec2(0.0,0.0);
	vec3 normalBump=vec3(normalScale,1.0,normalScale);
	vec3 normalBump0=vec3(normalScale0,1.0,normalScale0);
	vec3 normalBump1=vec3(normalScale1,1.0,normalScale1);

	float t=clamp((-pos.z-10000.0)/50000.0,0.0,1.0);
	normalBump1=mix(normalBump1,vec3(0.0,1.0,0.0),t);
	
	vec3 macroNormal=texture2D(waveNormals1,((texcoord2.st*0.125))).xyz;
	macroNormal=mix(macroNormal,texture2D(waveNormals1,((texcoord2.st*0.0125))).xyz,t);
	vec3 wavesNormal0=	texture2D(waveNormals0,(texcoord0.st)).xyz*normalBump0+macroNormal*normalBump1;

	vec3 normal0=vec3(0.0,0.0,0.0);	
	normal0.xz=texture2D(waveNormalsDetail,texcoord1.st).xz*normalBump0.xz*2.0;
	normal0=normal0+wavesNormal0.xyz+baseNormal*normalBump;
	
	float foamMul0=mix(foamDensityMultiplier0,0.0,t);
	float foamMul1=mix(foamDensityMultiplier1,0.0,t);
	
// ------------- FOAM ---------------	
	// ------------- FOAM ---------------	
	vec3 foamAmount;
	foamAmount.x=texture2D(foldmap,texcoord2.st*0.125).x*choppiness1;
	foamAmount.y=texture2D(foldmap,texcoord2.st*0.0125).x*choppiness1;//*foamMul;	
	foamAmount.z=texture2D(foldmap,texcoord0.st).y*choppiness0;//*foamMul;	
	// ----------------------------------
	float finalfoamAmount=(mix(foamAmount.x,foamAmount.y,t)*foamMul1)+foamAmount.z*foamMul0;
	finalfoamAmount=clamp((finalfoamAmount-1.0+min((foamMul0+foamMul1)*0.5,1.0))*2.0f,0.0,1.0);
	// ----------------------------------
	
	float slope=1.0-baseNormal.y;
	
	float dir=clamp(dot(wdir.xy,baseNormal.xz),0.0,1.0);
	float localslope=clamp((slope-0.9),0.0,1.0);
	float backslope=clamp((slope+0.5),0.0,1.0);
	
	if(-pos.z<200000.0)
	{
		vec2 UVp=normal0.xz*0.01;
		foamDensity=(texture2D(foam,texcoord0.st+UVp).g+texture2D(foam,texcoord3.st+UVp).rgb)-vec3((texture2D(foam,texcoord1.st+UVp).g)*0.5);
		foamDensity = clamp(foamDensity,vec3(0.0),vec3(1.0));
	}
	
	gl_FragData[0].xyz=deepColor;
	gl_FragData[0].a=density;
	
	gl_FragData[1].xy=encode(normal0.xyz);
	gl_FragData[1].z=specularity;
	gl_FragData[1].a=sss;
	
	gl_FragData[2].r=foamWidth*4.0;
	gl_FragData[2].g=roughness;
	
	float saturatedFoam=clamp(foamWidth,0.0,1.0);
	float cd=1.0-saturatedFoam;
	//float fw=clamp((coastDepth-cd)/saturatedFoam,0.0,1.0);
	gl_FragData[2].b=pow(finalfoamAmount,2.2);
	gl_FragData[2].a=mix(mix(foamDensity.r,foamDensity.g,clamp(gl_FragData[2].b,0.0,1.0)),foamDensity.b,clamp(gl_FragData[2].b,0.0,1.0));
}
